package h.com.serialapp.activity.fragment

import android.os.Bundle
import android.os.Handler
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ArrayAdapter
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.Packet
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.ICMessage
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_mifare.view.*

/**
 * Created by hxd on 2018/10/21.
 */
class Mifare_Classic : BasesFragment(), AdapterView.OnItemSelectedListener {

    lateinit var views: View
    var logAdapter: LogAdapter = LogAdapter()

    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    var handler = Handler(Handler.Callback { msg ->
        when (msg.what) {
            1 -> {
                views.et_tag_type.setText(icObject.tag_Type)
                views.et_sak.setText(icObject.sak)
                views.et_uid_number.setText(icObject.uiD_number)
            }
        }
        false
    })


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        var view = inflater!!.inflate(R.layout.view_mifare, null)
        view.lv_log.adapter = logAdapter
        views = view
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }
        initView()
        return view
    }

    var key_types: String = "KEYA"
    var add: String = "0"
    lateinit var array: Array<String>
    lateinit var arrays: Array<String>
    fun initView() {
        array = resources.getStringArray(R.array.block_addr)
        arrays = resources.getStringArray(R.array.key)
        views.spinner_addr.adapter = ArrayAdapter<String>(activity, R.layout.spinner_default_item, array)
        views.spinner_key_type.adapter = ArrayAdapter<String>(activity, R.layout.spinner_default_item, arrays)
        views.spinner_key_type.onItemSelectedListener = this
        views.spinner_addr.onItemSelectedListener = this
        btListener()
    }

    lateinit var icObject: ICMessage
    lateinit var current: String

    fun btListener() {
        var idle = byteArrayOf(10, 26)
        var all = byteArrayOf(10, 52)
        views.bt_idle.setOnClickListener {
            CommPacket.PiccActivate(Packet(idle, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }//Activity_IDLE按钮监听
        views.bt_all.setOnClickListener {
            CommPacket.PiccActivate(Packet(all, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }//Activity_ALL按钮监听
        views.bt_apduChannel.setOnClickListener {
            CommPacket.PiccTransfer(views.et_apdu.text.toString(), SerialReadThread.ReaderListener { message ->
                Log.i("CommPaket PiccTransfer", message)
//                icObject = message
//                handler.sendEmptyMessage(1)
            })
        }//APDU_Channel按钮监听
        views.bt_authenticate.setOnClickListener {
            // CommPacket.PiccAuthKey(views.et_uid_number.text.toString(), SerialReadThread.ReaderListener { msg -> Log.i("CommPaket PiccAuthKey", msg) }, views.spinner_key_type.text1.text.toString(), views.spinner_addr.text1.text.toString())
            //  CommPacket.PiccAuthKey("0216F943", "KEYA","05","FFFFFFFFFFFF",SerialReadThread.ReaderListener { msg -> Log.i("CommPaket PiccAuthKey", msg) } )
            CommPacket.PiccAuthKey(views.et_uid_number.text.toString(), key_types, add, views.et_key.text.toString(), SerialReadThread.ReaderListener { msg -> Log.i("CommPaket PiccAuthKey", msg) })
        }
        views.bt_readBlock.setOnClickListener {
            CommPacket.PiccRead(add, SerialReadThread.ReaderListener { msg -> Log.i("CommPaket PiccRead", msg) })
        }
        views.bt_writeBlock.setOnClickListener { CommPacket.PiccWrite(views.et_write.text.toString(),add, SerialReadThread.ReaderListener { msg -> Log.i("CommPacket", msg) }) }
        views.bt_readAllBlock.setOnClickListener { }//Read ALL Block
        views.bt_eWallet.setOnClickListener { }//E-Wallet
    }

    override fun onItemSelected(parent: AdapterView<*>, view: View, position: Int, id: Long) {

        // Spinner 选择监听
        when (parent.id) {
            R.id.spinner_key_type -> {
                key_types = arrays.get(position)
            }
            R.id.spinner_addr -> {
                add = array.get(position)
            }
        }
    }

    override fun onNothingSelected(parent: AdapterView<*>) {
        // 空实现
    }

}